/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.process.model;

public class CloudBpmnError
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String errorCode;

    public CloudBpmnError(String errorCode) {
        this(errorCode, errorCode);
    }

    public CloudBpmnError(String errorCode, String message) {
        super(message);
        this.requireValidErrorCode(errorCode);
        this.errorCode = errorCode;
    }

    public CloudBpmnError(String errorCode, Throwable cause) {
        super(cause);
        this.requireValidErrorCode(errorCode);
        this.errorCode = errorCode;
    }

    public CloudBpmnError(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.requireValidErrorCode(errorCode);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    protected void requireValidErrorCode(String errorCode) {
        if (errorCode == null) {
            throw new IllegalArgumentException("Error Code must not be null.");
        }
        if (errorCode.length() < 1) {
            throw new IllegalArgumentException("Error Code must not be empty.");
        }
    }
}

