/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ActivitiMessagingDestinationTransformer
implements Function<String, String> {
    private static final Logger log = LoggerFactory.getLogger(ActivitiMessagingDestinationTransformer.class);
    private final ActivitiCloudMessagingProperties messagingProperties;

    public ActivitiMessagingDestinationTransformer(ActivitiCloudMessagingProperties messagingProperties) {
        this.messagingProperties = messagingProperties;
    }

    @Override
    public String apply(String source) {
        ActivitiCloudMessagingProperties.DestinationProperties destinationProperties = this.messagingProperties.getDestinations().get(source);
        String prefix = Optional.ofNullable(destinationProperties).map(ActivitiCloudMessagingProperties.DestinationProperties::getPrefix).orElseGet(this::getPrefix);
        String separator = Optional.ofNullable(destinationProperties).map(ActivitiCloudMessagingProperties.DestinationProperties::getSeparator).orElseGet(this::getSeparator);
        String scope = Optional.ofNullable(destinationProperties).map(ActivitiCloudMessagingProperties.DestinationProperties::getScope).orElse(null);
        String name = Optional.ofNullable(destinationProperties).map(it -> it.getName()).filter(StringUtils::hasText).orElse(source);
        log.debug("Processing source destination '{}' with prefix '{}' and separator '{} to target name '{}' with scope '{}'", new Object[]{source, prefix, separator, name, scope});
        String target = Stream.of(name.split(",")).map(it -> {
            StringBuilder value = new StringBuilder();
            if (StringUtils.hasText((String)prefix)) {
                value.append(prefix).append(separator);
            }
            value.append((String)it);
            if (StringUtils.hasText((String)scope)) {
                value.append(separator).append(scope);
            }
            return value.toString();
        }).collect(Collectors.joining(","));
        return this.messagingProperties.isDestinationTransformersEnabled() ? this.messagingProperties.transformDestination().apply(target) : target;
    }

    public String getPrefix() {
        return this.messagingProperties.getDestinationPrefix();
    }

    public String getSeparator() {
        return this.messagingProperties.getDestinationSeparator();
    }
}

