/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.activiti.cloud.common.messaging.functional.ConnectorGateway;
import org.activiti.cloud.common.messaging.functional.ConsumerGateway;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.context.config.SmartCompositeMessageConverter;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.utils.PrimitiveTypesFromStringMessageConverter;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractFunctionalBindingConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private SmartCompositeMessageConverter smartCompositeMessageConverter;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)(this.getClass().getSimpleName() + " can not process beans because the application context is null"));
        this.applicationContext = applicationContext;
    }

    protected StreamBridge getStreamBridge() {
        return (StreamBridge)this.applicationContext.getBean(StreamBridge.class);
    }

    public static String getOutBinding(String bindingName) {
        return AbstractFunctionalBindingConfiguration.getOutBinding(bindingName, 0);
    }

    public static String getOutBinding(String bindingName, int arity) {
        return String.format("%s-out-%d", bindingName, arity);
    }

    public static String getInBinding(String bindingName) {
        return AbstractFunctionalBindingConfiguration.getInBinding(bindingName, 0);
    }

    public static String getInBinding(String bindingName, int arity) {
        return String.format("%s-in-%d", bindingName, arity);
    }

    protected Class<?> getGatewayInterface(boolean hasOutput) {
        if (hasOutput) {
            return ConnectorGateway.class;
        }
        return ConsumerGateway.class;
    }

    protected SimpleFunctionRegistry.FunctionInvocationWrapper functionFromDefinition(String definition) {
        FunctionRegistry functionRegistry = (FunctionRegistry)this.applicationContext.getBean(FunctionRegistry.class);
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionRegistry.lookup(definition + FunctionRegistration.REGISTRATION_NAME_SUFFIX);
        Assert.notNull((Object)function, (String)("Failed to lookup function '" + definition + "'"));
        return function;
    }

    protected Type discoverFunctionType(Object bean, String beanName) {
        return FunctionTypeUtils.discoverFunctionType((Object)bean, (String)beanName, (GenericApplicationContext)((GenericApplicationContext)GenericApplicationContext.class.cast(this.applicationContext)));
    }

    protected String registerFunctionRegistration(String functionName, FunctionRegistration functionRegistration) {
        String beanName = functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX;
        functionRegistration.setBeanName(beanName);
        ((GenericApplicationContext)GenericApplicationContext.class.cast(this.applicationContext)).registerBean(beanName, FunctionRegistration.class, () -> functionRegistration, new BeanDefinitionCustomizer[0]);
        return beanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompositeMessageConverter getMessageConverter() {
        AbstractFunctionalBindingConfiguration abstractFunctionalBindingConfiguration = this;
        synchronized (abstractFunctionalBindingConfiguration) {
            if (this.smartCompositeMessageConverter == null) {
                AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
                ArrayList<Object> messageConverters = new ArrayList<Object>();
                JsonMapper jsonMapper = (JsonMapper)beanFactory.getBean(JsonMapper.class);
                messageConverters.add(new JsonMessageConverter(jsonMapper));
                messageConverters.add(new ByteArrayMessageConverter());
                messageConverters.add(new StringMessageConverter());
                messageConverters.add(new PrimitiveTypesFromStringMessageConverter((ConversionService)new DefaultConversionService()));
                this.smartCompositeMessageConverter = new SmartCompositeMessageConverter(messageConverters);
            }
        }
        return this.smartCompositeMessageConverter;
    }

    protected MessageConverterConfigurer getMessageConverterConfigurer() {
        return (MessageConverterConfigurer)this.applicationContext.getBean("messageConverterConfigurer", MessageConverterConfigurer.class);
    }

    protected String registerConnectorFlowFunction(IntegrationFlow connectorFlow, String beanName) {
        Consumer<Message> connectorFlowFunction = arg_0 -> ((MessageChannel)connectorFlow.getInputChannel()).send(arg_0);
        FunctionRegistration connectorFlowFunctionRegistration = new FunctionRegistration(connectorFlowFunction, new String[0]).type((Type)new MessageConsumerParametrizedType());
        return this.registerFunctionRegistration(beanName, connectorFlowFunctionRegistration);
    }

    static class MessageConsumerParametrizedType
    implements ParameterizedType {
        MessageConsumerParametrizedType() {
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{Message.class};
        }

        @Override
        public Type getRawType() {
            return Consumer.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

