/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class FunctionRouterExecutorFactory
implements Function<String, ExecutorService> {
    private final Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    private Duration timeout = Duration.ofSeconds(5L);
    private final Function<String, ExecutorService> executorServiceFactory = registration -> Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName((String)registration);
        return thread;
    });

    @Override
    public ExecutorService apply(String key) {
        return this.executors.computeIfAbsent(key, this.executorServiceFactory);
    }

    @PreDestroy
    public void destroy() {
        try {
            this.shutdown();
            if (!this.awaitTermination(this.timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                this.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.shutdownNow();
        }
        finally {
            this.executors.clear();
        }
    }

    public void shutdown() {
        this.executors.values().forEach(ExecutorService::shutdown);
    }

    public void shutdownNow() {
        this.executors.values().forEach(ExecutorService::shutdownNow);
    }

    public boolean awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        List<CompletableFuture> cfs = this.executors.values().stream().map(executor -> CompletableFuture.supplyAsync(() -> {
            try {
                return executor.awaitTermination(timeout, timeUnit);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                return false;
            }
        })).toList();
        return (Boolean)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])cfs.toArray(CompletableFuture[]::new)).thenApply(v -> cfs.stream().map(CompletableFuture::join).allMatch(Boolean.TRUE::equals))).join();
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

