/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.HashMap;
import java.util.Map;
import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ActivitiMessagingEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    protected static final String ACTIVITI_CLOUD_MESSAGING_BROKER_KEY = "activiti.cloud.messaging.broker";
    protected static final String SPRING_CLOUD_STREAM_DEFAULT_BINDER_KEY = "spring.cloud.stream.default-binder";
    protected static final String MANAGEMENT_HEALTH_RABBIT_ENABLED_KEY = "management.health.rabbit.enabled";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ActivitiCloudMessagingProperties.MessagingBroker messagingBroker = (ActivitiCloudMessagingProperties.MessagingBroker)environment.getProperty(ACTIVITI_CLOUD_MESSAGING_BROKER_KEY, ActivitiCloudMessagingProperties.MessagingBroker.class, (Object)ActivitiCloudMessagingProperties.MessagingBroker.rabbitmq);
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource(this.getClass().getSimpleName(), this.resolvePropertiesToSet(messagingBroker, environment)));
    }

    private Map<String, Object> resolvePropertiesToSet(ActivitiCloudMessagingProperties.MessagingBroker messagingBroker, ConfigurableEnvironment environment) {
        HashMap<String, Object> extraProperties = new HashMap<String, Object>();
        extraProperties.put(MANAGEMENT_HEALTH_RABBIT_ENABLED_KEY, ActivitiCloudMessagingProperties.MessagingBroker.rabbitmq.equals((Object)messagingBroker));
        extraProperties.put(SPRING_CLOUD_STREAM_DEFAULT_BINDER_KEY, this.resolveDefaultBinder(messagingBroker));
        return extraProperties;
    }

    private String resolveDefaultBinder(ActivitiCloudMessagingProperties.MessagingBroker messagingBroker) {
        return switch (messagingBroker) {
            case ActivitiCloudMessagingProperties.MessagingBroker.kafka -> "kafka";
            case ActivitiCloudMessagingProperties.MessagingBroker.aws -> "aws";
            default -> "rabbit";
        };
    }
}

