/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.streams;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.audit.api.converters.APIEventToEntityConverters;
import org.activiti.cloud.services.audit.api.converters.EventToEntityConverter;
import org.activiti.cloud.services.audit.api.streams.AuditConsumerChannelHandler;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW)
public class AuditConsumerChannelHandlerImpl
implements AuditConsumerChannelHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditConsumerChannelHandlerImpl.class);
    private final EventsRepository eventsRepository;
    private final APIEventToEntityConverters eventConverters;

    public AuditConsumerChannelHandlerImpl(EventsRepository eventsRepository, APIEventToEntityConverters eventConverters) {
        this.eventsRepository = eventsRepository;
        this.eventConverters = eventConverters;
    }

    @Override
    public void receiveCloudRuntimeEvent(@Headers Map<String, Object> headers, CloudRuntimeEvent<?, ?> ... events) {
        if (events != null) {
            AtomicInteger counter = new AtomicInteger(0);
            ArrayList<AuditEventEntity> entities = new ArrayList<AuditEventEntity>();
            for (CloudRuntimeEvent<?, ?> event : events) {
                EventToEntityConverter converter = this.eventConverters.getConverterByEventTypeName(event.getEventType().name());
                if (converter != null) {
                    ((CloudRuntimeEventImpl)event).setMessageId(headers.get("id").toString());
                    ((CloudRuntimeEventImpl)event).setSequenceNumber(Integer.valueOf(counter.getAndIncrement()));
                    entities.add((AuditEventEntity)converter.convertToEntity(event));
                    continue;
                }
                LOGGER.warn(">>> Ignoring CloudRuntimeEvents type: " + event.getEventType().name());
            }
            this.eventsRepository.saveAll(entities);
        }
    }
}

