/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import org.activiti.cloud.services.audit.api.AuditException;
import org.activiti.cloud.services.audit.jpa.events.VariableValue;

public class VariableValueJpaConverter
implements AttributeConverter<VariableValue<?>, String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(VariableValue<?> entity) {
        try {
            return objectMapper.writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            throw new AuditException("Unable to serialize object.", e);
        }
    }

    public VariableValue<?> convertToEntityAttribute(String entityTextRepresentation) {
        try {
            if (entityTextRepresentation != null && entityTextRepresentation.length() > 0) {
                return (VariableValue)objectMapper.readValue(entityTextRepresentation, VariableValue.class);
            }
            return null;
        }
        catch (IOException e) {
            throw new AuditException("Unable to deserialize object.", e);
        }
    }
}

