/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.repository;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.SpecSearchCriteria;
import org.springframework.data.jpa.domain.Specification;

public class EventSpecification
implements Specification<AuditEventEntity> {
    private SpecSearchCriteria criteria;

    public EventSpecification(SpecSearchCriteria criteria) {
        this.criteria = criteria;
    }

    public SpecSearchCriteria getCriteria() {
        return this.criteria;
    }

    public Predicate toPredicate(Root<AuditEventEntity> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        switch (this.criteria.getOperation()) {
            case EQUALITY: {
                return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
            }
            case NEGATION: {
                return builder.notEqual((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
            }
            case GREATER_THAN: {
                return builder.greaterThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case GREATER_THAN_EQUAL: {
                return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LESS_THAN: {
                return builder.lessThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LESS_THAN_EQUAL: {
                return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LIKE: {
                return builder.like((Expression)root.get(this.criteria.getKey()), this.criteria.getValue().toString());
            }
            case STARTS_WITH: {
                return builder.like((Expression)root.get(this.criteria.getKey()), String.valueOf(this.criteria.getValue()) + "%");
            }
            case ENDS_WITH: {
                return builder.like((Expression)root.get(this.criteria.getKey()), "%" + String.valueOf(this.criteria.getValue()));
            }
            case CONTAINS: {
                return builder.like((Expression)root.get(this.criteria.getKey()), "%" + String.valueOf(this.criteria.getValue()) + "%");
            }
        }
        return null;
    }
}

