/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.MappedSuperclass;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskRuntimeEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.TaskJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@MappedSuperclass
public abstract class TaskAuditEventEntity
extends AuditEventEntity {
    @Convert(converter=TaskJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private Task task;
    private String taskId;
    private String taskName;

    public TaskAuditEventEntity() {
    }

    public TaskAuditEventEntity(CloudTaskRuntimeEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setTask((Task)cloudEvent.getEntity());
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        if (task != null) {
            this.taskId = task.getId();
            this.taskName = task.getName();
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskAuditEventEntity [task=").append(this.task).append(", taskId=").append(this.taskId).append(", taskName=").append(this.taskName).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

