/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.MappedSuperclass;
import org.activiti.api.process.model.BPMNMessage;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNMessageEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.MessageJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@MappedSuperclass
public abstract class MessageAuditEventEntity
extends AuditEventEntity {
    @Convert(converter=MessageJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private BPMNMessage message;

    public MessageAuditEventEntity() {
    }

    public MessageAuditEventEntity(CloudBPMNMessageEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.message = (BPMNMessage)cloudEvent.getEntity();
        if (this.message != null) {
            this.setProcessDefinitionId(this.message.getProcessDefinitionId());
            this.setProcessInstanceId(this.message.getProcessInstanceId());
            this.setEntityId(this.message.getElementId());
        }
    }

    public BPMNMessage getMessage() {
        return this.message;
    }

    public void setMessage(BPMNMessage message) {
        this.message = message;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageAuditEventEntity [message=").append(this.message).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

