/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.converters;

import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.IncidentEvent;
import org.activiti.cloud.api.process.model.impl.events.CloudIncidentCreatedEventImpl;
import org.activiti.cloud.services.audit.jpa.converters.BaseEventToEntityConverter;
import org.activiti.cloud.services.audit.jpa.converters.EventContextInfoAppender;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.events.IncidentCreatedEventEntity;

public class IncidentCreatedEventConverter
extends BaseEventToEntityConverter {
    public IncidentCreatedEventConverter(EventContextInfoAppender eventContextInfoAppender) {
        super(eventContextInfoAppender);
    }

    @Override
    public String getSupportedEvent() {
        return IncidentEvent.IncidentEventType.INCIDENT_CREATED.toString();
    }

    @Override
    protected IncidentCreatedEventEntity createEventEntity(CloudRuntimeEvent cloudRuntimeEvent) {
        return new IncidentCreatedEventEntity((IncidentEvent)IncidentEvent.class.cast(cloudRuntimeEvent));
    }

    @Override
    protected CloudRuntimeEventImpl<?, ?> createAPIEvent(AuditEventEntity auditEventEntity) {
        IncidentCreatedEventEntity incidentCreatedEventEntity = (IncidentCreatedEventEntity)IncidentCreatedEventEntity.class.cast(auditEventEntity);
        return new CloudIncidentCreatedEventImpl(incidentCreatedEventEntity.getEventId(), incidentCreatedEventEntity.getTimestamp(), incidentCreatedEventEntity.getIncidentContext(), incidentCreatedEventEntity.getErrorClassName(), incidentCreatedEventEntity.getErrorCode(), incidentCreatedEventEntity.getErrorMessage(), incidentCreatedEventEntity.getStackTraceElements());
    }
}

