/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import java.util.List;
import org.activiti.cloud.api.process.model.IncidentEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.ListOfStackTraceElementsJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.IncidentAuditEventEntity;
import org.activiti.cloud.services.audit.jpa.events.StringUtils;

@Entity(name="IncidentCreatedEvent")
@DiscriminatorValue(value="IncidentCreatedEvent")
public class IncidentCreatedEventEntity
extends IncidentAuditEventEntity {
    private static final int ERROR_MESSAGE_LENGTH = 255;
    protected static final String INCIDENT_CREATED_EVENT = "IncidentCreatedEvent";
    private String errorCode;
    @Column(length=255)
    private String errorMessage;
    private String errorClassName;
    @Convert(converter=ListOfStackTraceElementsJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private List<StackTraceElement> stackTraceElements;

    protected IncidentCreatedEventEntity() {
    }

    public IncidentCreatedEventEntity(IncidentEvent event) {
        super(event);
        this.errorCode = event.getErrorCode();
        this.errorMessage = StringUtils.truncate(event.getErrorMessage(), 255);
        this.errorClassName = event.getErrorClassName();
        this.stackTraceElements = event.getStackTraceElements();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = StringUtils.truncate(errorMessage, 255);
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public List<StackTraceElement> getStackTraceElements() {
        return this.stackTraceElements;
    }

    public void setStackTraceElements(List<StackTraceElement> stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    @Override
    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("IncidentCreatedEventEntity [errorMessage=").append(this.errorCode).append(", errorCode=").append(this.errorMessage).append(", incidentContext=").append(this.getIncidentContext()).append(", errorClassName=").append(this.errorClassName).append(", stackTraceElements=").append(this.stackTraceElements != null ? this.stackTraceElements.subList(0, Math.min(this.stackTraceElements.size(), 10)) : null).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

