/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.converters;

import org.activiti.api.task.model.events.TaskRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.task.model.events.CloudTaskUpdatedEvent;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskUpdatedEventImpl;
import org.activiti.cloud.services.audit.jpa.converters.BaseEventToEntityConverter;
import org.activiti.cloud.services.audit.jpa.converters.EventContextInfoAppender;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.events.TaskUpdatedEventEntity;

public class TaskUpdatedEventConverter
extends BaseEventToEntityConverter {
    public TaskUpdatedEventConverter(EventContextInfoAppender eventContextInfoAppender) {
        super(eventContextInfoAppender);
    }

    @Override
    public String getSupportedEvent() {
        return TaskRuntimeEvent.TaskEvents.TASK_UPDATED.name();
    }

    @Override
    public TaskUpdatedEventEntity createEventEntity(CloudRuntimeEvent cloudRuntimeEvent) {
        return new TaskUpdatedEventEntity((CloudTaskUpdatedEvent)cloudRuntimeEvent);
    }

    @Override
    protected CloudRuntimeEventImpl<?, ?> createAPIEvent(AuditEventEntity auditEventEntity) {
        TaskUpdatedEventEntity taskUpdatedEventEntity = (TaskUpdatedEventEntity)auditEventEntity;
        return new CloudTaskUpdatedEventImpl(taskUpdatedEventEntity.getEventId(), taskUpdatedEventEntity.getTimestamp(), taskUpdatedEventEntity.getTask());
    }
}

