/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.converters;

import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.events.CloudProcessDeletedEvent;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessDeletedEventImpl;
import org.activiti.cloud.services.audit.jpa.converters.BaseEventToEntityConverter;
import org.activiti.cloud.services.audit.jpa.converters.EventContextInfoAppender;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.events.ProcessDeletedAuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;

public class ProcessDeletedEventConverter
extends BaseEventToEntityConverter {
    private final String PROCESS_INSTANCE_ID = "processInstanceId";
    private final String TIMESTAMP = "timestamp";
    private final String MISSING_PROCESS_INSTANCE = "Process Instance %s not found";
    private final EventsRepository eventsRepository;

    public ProcessDeletedEventConverter(EventsRepository eventsRepository, EventContextInfoAppender eventContextInfoAppender) {
        super(eventContextInfoAppender);
        this.eventsRepository = eventsRepository;
    }

    @Override
    public String getSupportedEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_DELETED.name();
    }

    @Override
    protected ProcessDeletedAuditEventEntity createEventEntity(CloudRuntimeEvent cloudRuntimeEvent) {
        return new ProcessDeletedAuditEventEntity((CloudProcessDeletedEvent)cloudRuntimeEvent);
    }

    @Override
    protected CloudRuntimeEventImpl<?, ?> createAPIEvent(AuditEventEntity auditEventEntity) {
        ProcessDeletedAuditEventEntity processDeletedAuditEventEntity = (ProcessDeletedAuditEventEntity)auditEventEntity;
        return new CloudProcessDeletedEventImpl(processDeletedAuditEventEntity.getEventId(), processDeletedAuditEventEntity.getTimestamp(), processDeletedAuditEventEntity.getProcessInstance());
    }
}

