/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableUpdatedEvent;
import org.activiti.cloud.services.audit.jpa.events.VariableAuditEventEntity;
import org.activiti.cloud.services.audit.jpa.events.VariableValue;
import org.activiti.cloud.services.audit.jpa.events.VariableValueJpaConverter;

@Entity(name="VariableUpdatedEvent")
@DiscriminatorValue(value="VariableUpdatedEvent")
public class VariableUpdatedEventEntity
extends VariableAuditEventEntity {
    protected static final String VARIABLE_UPDATED_EVENT = "VariableUpdatedEvent";
    @Convert(converter=VariableValueJpaConverter.class)
    @Column(name="variable_previous_value", columnDefinition="text")
    private VariableValue<?> previousValue;

    public VariableUpdatedEventEntity() {
    }

    public VariableUpdatedEventEntity(CloudVariableUpdatedEvent cloudEvent) {
        super((CloudVariableEvent)cloudEvent);
        this.previousValue = new VariableValue<Object>(cloudEvent.getPreviousValue());
    }

    public VariableValue<?> getPreviousValue() {
        return this.previousValue;
    }

    public void setPreviousValue(VariableValue<?> previousValue) {
        this.previousValue = previousValue;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VariableUpdatedEventEntity [toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

