/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.process.model.BPMNError;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNErrorReceivedEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.ErrorJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity
@DiscriminatorValue(value="ErrorReceivedEvent")
public class ErrorReceivedAuditEventEntity
extends AuditEventEntity {
    protected static final String ERROR_RECEIVED_EVENT = "ErrorReceivedEvent";
    @Convert(converter=ErrorJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private BPMNError error;

    public ErrorReceivedAuditEventEntity() {
    }

    public ErrorReceivedAuditEventEntity(CloudBPMNErrorReceivedEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setError((BPMNError)cloudEvent.getEntity());
        if (this.error != null) {
            this.setProcessDefinitionId(this.error.getProcessDefinitionId());
            this.setProcessInstanceId(this.error.getProcessInstanceId());
            this.setEntityId(this.error.getElementId());
        }
    }

    public BPMNError getError() {
        return this.error;
    }

    public void setError(BPMNError error) {
        this.error = error;
    }
}

