/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.service;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;

public class AuditEventsAdminService {
    private final EventsRepository eventsRepository;

    public AuditEventsAdminService(EventsRepository eventsRepository) {
        this.eventsRepository = eventsRepository;
    }

    public Collection<AuditEventEntity> findAuditsBetweenDates(LocalDate fromDate, LocalDate toDate) {
        if (fromDate.isAfter(toDate)) {
            throw new IllegalArgumentException("From date cannot be after to date");
        }
        long daysBetween = ChronoUnit.DAYS.between(fromDate, toDate);
        if (daysBetween > 31L) {
            throw new IllegalArgumentException("Difference between dates cannot be more than 31 days");
        }
        Long startDateTime = fromDate.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        Long endDateTime = toDate.atStartOfDay().plusDays(1L).toInstant(ZoneOffset.UTC).toEpochMilli();
        return this.eventsRepository.findAllByTimestampBetweenOrderByTimestampDesc(startDateTime, endDateTime);
    }
}

