/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.audit.api.controllers.AuditEventsAdminController;
import org.activiti.cloud.services.audit.api.converters.APIEventToEntityConverters;
import org.activiti.cloud.services.audit.api.converters.CloudRuntimeEventType;
import org.activiti.cloud.services.audit.jpa.assembler.EventRepresentationModelAssembler;
import org.activiti.cloud.services.audit.jpa.controllers.AuditEventsExporter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;
import org.activiti.cloud.services.audit.jpa.service.AuditEventsAdminService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/events"}, produces={"application/hal+json", "application/json"})
public class AuditEventsAdminControllerImpl
implements AuditEventsAdminController {
    private final EventsRepository eventsRepository;
    private final EventRepresentationModelAssembler eventRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<CloudRuntimeEvent<?, CloudRuntimeEventType>> pagedCollectionModelAssembler;
    private final APIEventToEntityConverters eventConverters;
    private final AuditEventsExporter auditEventsExporter;
    private final AuditEventsAdminService auditEventsAdminService;

    @Autowired
    public AuditEventsAdminControllerImpl(EventsRepository eventsRepository, EventRepresentationModelAssembler eventRepresentationModelAssembler, APIEventToEntityConverters eventConverters, AlfrescoPagedModelAssembler<CloudRuntimeEvent<?, CloudRuntimeEventType>> pagedCollectionModelAssembler, ObjectMapper objectMapper, AuditEventsAdminService auditEventsAdminService) {
        this.eventsRepository = eventsRepository;
        this.eventRepresentationModelAssembler = eventRepresentationModelAssembler;
        this.eventConverters = eventConverters;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.auditEventsExporter = new AuditEventsExporter(objectMapper);
        this.auditEventsAdminService = auditEventsAdminService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudRuntimeEvent<?, CloudRuntimeEventType>>> findAll(Pageable pageable) {
        Page allAuditInPage = this.eventsRepository.findAll(pageable);
        List<CloudRuntimeEvent<?, CloudRuntimeEventType>> events = this.toCloudRuntimeEvents(allAuditInPage.getContent());
        return this.pagedCollectionModelAssembler.toModel(pageable, (Page)new PageImpl(events, pageable, allAuditInPage.getTotalElements()), (RepresentationModelAssembler)this.eventRepresentationModelAssembler);
    }

    @GetMapping(path={"/export/{fileName}"})
    public void export(@PathVariable(value="fileName") String fileName, @RequestParam(value="from", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate from, @RequestParam(value="to", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate to, HttpServletResponse response) throws Exception {
        Collection<AuditEventEntity> audits = this.auditEventsAdminService.findAuditsBetweenDates(from, to);
        List<CloudRuntimeEvent<?, CloudRuntimeEventType>> events = this.toCloudRuntimeEvents(audits);
        this.auditEventsExporter.exportCsv(events, fileName, response);
    }

    private List<CloudRuntimeEvent<?, CloudRuntimeEventType>> toCloudRuntimeEvents(Iterable<AuditEventEntity> allAuditInPage) {
        ArrayList events = new ArrayList();
        for (AuditEventEntity aee : allAuditInPage) {
            events.add(this.eventConverters.getConverterByEventTypeName(aee.getEventType()).convertToAPI((Object)aee));
        }
        return events;
    }
}

