/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.audit.api.converters.CloudRuntimeEventType;
import org.activiti.cloud.services.audit.jpa.controllers.csv.CsvLogEntry;
import org.activiti.cloud.services.audit.jpa.controllers.csv.ObjectToJsonStrategy;

public class AuditEventsExporter {
    private static final String HEADER_ATTACHMENT_FILENAME = "attachment;filename=";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CSV_CONTENT_TYPE = "text/csv";
    private ObjectToJsonStrategy objectToJsonStrategy;

    public AuditEventsExporter(ObjectMapper objectMapper) {
        this.objectToJsonStrategy = new ObjectToJsonStrategy(objectMapper);
    }

    public void exportCsv(List<CloudRuntimeEvent<?, CloudRuntimeEventType>> events, String fileName, HttpServletResponse response) throws Exception {
        this.setHttpHeaders(fileName, response);
        this.writeEventsAsCsv(events, response);
    }

    private void setHttpHeaders(String fileName, HttpServletResponse response) {
        response.setContentType(CSV_CONTENT_TYPE);
        response.setHeader(HEADER_CONTENT_DISPOSITION, HEADER_ATTACHMENT_FILENAME + fileName);
    }

    private void writeEventsAsCsv(List<CloudRuntimeEvent<?, CloudRuntimeEventType>> events, HttpServletResponse response) throws Exception {
        List<CsvLogEntry> entries = this.toCsvLogEntryList(events);
        PrintWriter writer = response.getWriter();
        StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withMappingStrategy((MappingStrategy)this.objectToJsonStrategy).build();
        beanToCsv.write(entries);
        writer.close();
    }

    private List<CsvLogEntry> toCsvLogEntryList(List<CloudRuntimeEvent<?, CloudRuntimeEventType>> events) {
        ArrayList<CsvLogEntry> entries = new ArrayList<CsvLogEntry>();
        for (CloudRuntimeEvent<?, CloudRuntimeEventType> event : events) {
            entries.add(new CsvLogEntry(event));
        }
        return entries;
    }
}

