/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.security;

import java.util.Map;
import java.util.Set;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.security.AlwaysTrueSpecification;
import org.activiti.cloud.services.audit.jpa.security.ApplicationProcessDefSecuritySpecification;
import org.activiti.cloud.services.audit.jpa.security.ApplicationSecuritySpecification;
import org.activiti.cloud.services.audit.jpa.security.ImpossibleSpecification;
import org.activiti.core.common.spring.security.policies.BaseSecurityPoliciesManagerImpl;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.activiti.core.common.spring.security.policies.conf.SecurityPoliciesProperties;
import org.springframework.data.jpa.domain.Specification;

public class SecurityPoliciesApplicationServiceImpl
extends BaseSecurityPoliciesManagerImpl
implements SecurityPoliciesManager {
    public SecurityPoliciesApplicationServiceImpl(SecurityManager securityManager, SecurityPoliciesProperties securityPoliciesProperties) {
        super(securityManager, securityPoliciesProperties);
    }

    public Specification<AuditEventEntity> createSpecWithSecurity(Specification<AuditEventEntity> spec, SecurityPolicyAccess securityPolicy) {
        if (spec == null) {
            spec = new AlwaysTrueSpecification();
        }
        if (!this.arePoliciesDefined()) {
            return spec;
        }
        Map restrictions = this.getAllowedKeys(new SecurityPolicyAccess[]{securityPolicy});
        for (String serviceName : restrictions.keySet()) {
            Set defKeys = (Set)restrictions.get(serviceName);
            if (defKeys != null && defKeys.size() > 0 && !defKeys.contains(this.securityPoliciesProperties.getWildcard())) {
                return spec.and(new ApplicationProcessDefSecuritySpecification(serviceName, defKeys));
            }
            if (defKeys == null || !defKeys.contains(this.securityPoliciesProperties.getWildcard())) continue;
            return spec.and(new ApplicationSecuritySpecification(serviceName));
        }
        if (this.arePoliciesDefined()) {
            return spec.and(new ImpossibleSpecification());
        }
        return spec;
    }

    public boolean canWrite(String processDefinitionKey) {
        return false;
    }

    public boolean canRead(String processDefinitionKey) {
        return false;
    }
}

