/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.controllers.csv;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.bean.AbstractBeanField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectToJsonConvertor
extends AbstractBeanField {
    private static final Logger logger = LoggerFactory.getLogger(ObjectToJsonConvertor.class);
    private ObjectMapper objectMapper;

    public ObjectToJsonConvertor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected Object convert(String s) {
        return null;
    }

    public String convertToWrite(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            logger.error("CSV export exception. Could not serialise event entity " + String.valueOf(value) + " to json.", (Throwable)e);
            throw new ObjectToJsonConversionException("Export to CSV failed. Could not serialise event entity.");
        }
    }

    class ObjectToJsonConversionException
    extends RuntimeException {
        ObjectToJsonConversionException(String message) {
            super(message);
        }
    }
}

