/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.controllers.csv;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvCustomBindByName;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.audit.jpa.controllers.csv.ObjectToJsonConvertor;

public class CsvLogEntry
implements CloudRuntimeEvent {
    @CsvBindByName
    private String time;
    @CsvBindByName
    private Integer sequenceNumber;
    @CsvBindByName
    private String messageId;
    @CsvBindByName
    private String entityId;
    @CsvBindByName
    private String id;
    @CsvCustomBindByName(converter=ObjectToJsonConvertor.class)
    private Object entity;
    @CsvBindByName
    private Enum<?> eventType;
    @CsvBindByName
    private String appVersion;
    @CsvBindByName
    private String serviceVersion;
    @CsvBindByName
    private String serviceType;
    @CsvBindByName
    private String serviceFullName;
    @CsvBindByName
    private String processInstanceId;
    @CsvBindByName
    private String appName;
    @CsvBindByName
    private String serviceName;
    @CsvBindByName
    private String businessKey;
    @CsvBindByName
    private String parentProcessInstanceId;
    @CsvBindByName
    private String processDefinitionId;
    @CsvBindByName
    private String processDefinitionKey;
    @CsvBindByName
    private Integer processDefinitionVersion;
    @CsvBindByName
    private String actor;

    public CsvLogEntry(CloudRuntimeEvent event) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.time = dateFormat.format(new Date(event.getTimestamp()));
        this.sequenceNumber = event.getSequenceNumber();
        this.messageId = event.getMessageId();
        this.entityId = event.getEntityId();
        this.id = event.getId();
        this.entity = event.getEntity();
        this.eventType = event.getEventType();
        this.appVersion = event.getAppVersion();
        this.serviceVersion = event.getServiceVersion();
        this.serviceType = event.getServiceType();
        this.serviceFullName = event.getServiceFullName();
        this.processInstanceId = event.getProcessInstanceId();
        this.appName = event.getAppName();
        this.serviceName = event.getServiceName();
        this.businessKey = event.getBusinessKey();
        this.parentProcessInstanceId = event.getParentProcessInstanceId();
        this.processDefinitionId = event.getProcessDefinitionId();
        this.processDefinitionKey = event.getProcessDefinitionKey();
        this.processDefinitionVersion = event.getProcessDefinitionVersion();
        this.actor = event.getActor();
    }

    public String getTime() {
        return this.time;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getActor() {
        return this.actor;
    }

    public String getId() {
        return this.id;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Long getTimestamp() {
        return null;
    }

    public Enum<?> getEventType() {
        return this.eventType;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceFullName() {
        return this.serviceFullName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }
}

