/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.identity.keycloak.config;

import feign.Contract;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.activiti.cloud.security.feign.ClientCredentialsAuthRequestInterceptor;
import org.activiti.cloud.security.feign.configuration.ClientCredentialsAuthConfiguration;
import org.activiti.cloud.services.identity.keycloak.ActivitiKeycloakProperties;
import org.activiti.cloud.services.identity.keycloak.KeycloakClientPrincipalDetailsProvider;
import org.activiti.cloud.services.identity.keycloak.KeycloakHealthService;
import org.activiti.cloud.services.identity.keycloak.KeycloakManagementService;
import org.activiti.cloud.services.identity.keycloak.KeycloakProperties;
import org.activiti.cloud.services.identity.keycloak.KeycloakUserGroupManager;
import org.activiti.cloud.services.identity.keycloak.client.KeycloakClient;
import org.activiti.cloud.services.identity.keycloak.validator.RealmValidationCheck;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

@AutoConfiguration
@PropertySource(value={"classpath:keycloak-client.properties"})
@ConditionalOnProperty(value={"activiti.cloud.services.oauth2.iam-name"}, havingValue="keycloak", matchIfMissing=true)
@EnableConfigurationProperties(value={ActivitiKeycloakProperties.class, KeycloakProperties.class})
public class ActivitiKeycloakAutoConfiguration {
    @Autowired
    private OAuth2AuthorizedClientService oAuth2AuthorizedClientService;
    @Autowired
    private ClientRegistrationRepository clientRegistrationRepository;

    @Bean(name={"userGroupManager"})
    @ConditionalOnMissingBean(value={KeycloakUserGroupManager.class})
    public KeycloakUserGroupManager keycloakUserGroupManager(KeycloakClient keycloakClient) {
        return new KeycloakUserGroupManager(keycloakClient);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    @ConditionalOnMissingBean
    public KeycloakClientPrincipalDetailsProvider keycloakClientPrincipalDetailsProvider(KeycloakClient keycloakClient) {
        return new KeycloakClientPrincipalDetailsProvider(keycloakClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public KeycloakManagementService identityManagementService(KeycloakClient keycloakClient) {
        return new KeycloakManagementService(keycloakClient);
    }

    @Bean(name={"identityHealthService"})
    @ConditionalOnMissingBean(value={KeycloakHealthService.class})
    public KeycloakHealthService keycloakHealthService(KeycloakUserGroupManager keycloakUserGroupManager) {
        return new KeycloakHealthService(keycloakUserGroupManager);
    }

    @Bean
    public RealmValidationCheck realmValidationCheck(@Value(value="${keycloak.auth-server-url}") String authServerUrl, @Value(value="${keycloak.realm}") String realm) {
        return new RealmValidationCheck(authServerUrl, realm);
    }

    @Bean
    public KeycloakClient keycloakClient(@Value(value="${keycloak.auth-server-url}/admin/realms/${keycloak.realm}/") String url, ObjectFactory<HttpMessageConverters> messageConverters, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        ClientCredentialsAuthConfiguration clientCredentialsAuthConfiguration = new ClientCredentialsAuthConfiguration();
        ClientRegistration clientRegistration = clientCredentialsAuthConfiguration.clientRegistration(this.clientRegistrationRepository, "keycloak");
        ClientCredentialsAuthRequestInterceptor clientCredentialsAuthRequestInterceptor = clientCredentialsAuthConfiguration.clientCredentialsAuthRequestInterceptor(this.oAuth2AuthorizedClientService, this.clientRegistrationRepository, clientRegistration);
        return (KeycloakClient)Feign.builder().contract((Contract)new SpringMvcContract()).encoder((Encoder)new SpringEncoder(messageConverters)).decoder((Decoder)new SpringDecoder(messageConverters, customizers)).requestInterceptor((RequestInterceptor)clientCredentialsAuthRequestInterceptor).target(KeycloakClient.class, url);
    }
}

