/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.identity.keycloak.client;

import feign.Headers;
import feign.Response;
import java.util.List;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakClientRepresentation;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakCredentialRepresentation;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakCredentialRequestRepresentation;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakGroup;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakMappingsRepresentation;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakRoleMapping;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakUser;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public interface KeycloakClient {
    @RequestMapping(method={RequestMethod.GET}, value={"/users"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakUser> searchUsers(@RequestParam(value="search") String var1, @RequestParam(value="first") Integer var2, @RequestParam(value="max") Integer var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/users"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakUser> searchUsersByUsername(@RequestParam(value="username") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}/role-mappings/realm/composite"})
    @Headers(value={"Content-Type: application/json"})
    @Cacheable(value={"userRoleMapping"})
    public List<KeycloakRoleMapping> getUserRoleMapping(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}/role-mappings/realm/available"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> getUserRoleMappingAvailable(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"/users/{id}/role-mappings/realm"})
    @Headers(value={"Content-Type: application/json"})
    public void addRealmLevelUserRoleMapping(@PathVariable(value="id") String var1, List<KeycloakRoleMapping> var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}/groups"})
    @Headers(value={"Content-Type: application/json"})
    @Cacheable(value={"userGroups"})
    public List<KeycloakGroup> getUserGroups(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}/role-mappings"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakMappingsRepresentation getUserRoles(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/groups"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakGroup> searchGroups(@RequestParam(value="search") String var1, @RequestParam(value="first") Integer var2, @RequestParam(value="max") Integer var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{id}/role-mappings/realm/composite"})
    @Headers(value={"Content-Type: application/json"})
    @Cacheable(value={"groupRoleMapping"})
    public List<KeycloakRoleMapping> getGroupRoleMapping(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{id}/role-mappings"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakMappingsRepresentation getAllGroupRoleMapping(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/clients"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakClientRepresentation> searchClients(@RequestParam(value="clientId", required=false) String var1, @RequestParam(value="first") Integer var2, @RequestParam(value="max") Integer var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}/role-mappings/clients/{client}/composite"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> getUserClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{id}/role-mappings/clients/{client}/composite"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> getGroupClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"clients/{id}/roles"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> getClientRoles(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"/users/{id}/role-mappings/clients/{client}"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> addUserClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2, @RequestBody List<KeycloakRoleMapping> var3);

    @RequestMapping(method={RequestMethod.POST}, value={"/groups/{id}/role-mappings/clients/{client}"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> addGroupClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2, @RequestBody List<KeycloakRoleMapping> var3);

    @RequestMapping(method={RequestMethod.DELETE}, value={"/users/{id}/role-mappings/clients/{client}"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> removeUserClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2, @RequestBody List<KeycloakRoleMapping> var3);

    @RequestMapping(method={RequestMethod.DELETE}, value={"/groups/{id}/role-mappings/clients/{client}"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> removeGroupClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2, @RequestBody List<KeycloakRoleMapping> var3);

    default public List<KeycloakUser> getUsersClientRoleMapping(String id, String roleName) {
        return this.getUsersClientRoleMapping(id, roleName, 0, 100);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"clients/{id}/roles/{role-name}/users"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakUser> getUsersClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="role-name") String var2, @RequestParam(value="first") Integer var3, @RequestParam(value="max") Integer var4);

    @RequestMapping(method={RequestMethod.GET}, value={"clients/{id}/service-account-user"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakUser getServiceAccountUserOfClient(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"clients/{id}/roles/{role-name}/groups"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakGroup> getGroupsClientRoleMapping(@PathVariable(value="id") String var1, @PathVariable(value="role-name") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"clients/{id}/roles/{role-name}"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakRoleMapping getRoleRepresentationForClient(@PathVariable(value="id") String var1, @PathVariable(value="role-name") String var2);

    @RequestMapping(method={RequestMethod.POST}, value={"clients/{id}/roles"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakRoleMapping createRoleRepresentationForClient(@PathVariable(value="id") String var1, @RequestBody KeycloakRoleMapping var2);

    default public List<KeycloakUser> getUsersByGroupId(String groupId) {
        return this.getUsersByGroupId(groupId, 0, 100);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{groupId}/members"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakUser> getUsersByGroupId(@PathVariable(value="groupId") String var1, @RequestParam(value="first") Integer var2, @RequestParam(value="max") Integer var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{id}"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakGroup getGroupById(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/groups"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakGroup> getAllGroups();

    @RequestMapping(method={RequestMethod.GET}, value={"/users"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakUser> getAllUsers(@RequestParam(name="max", required=false, defaultValue="100") Integer var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/count"})
    @Headers(value={"Content-Type: application/json"})
    public Integer countAllUsers();

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakUser getUserById(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/group-by-path/{path}"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakGroup getGroupByPath(@PathVariable(value="path") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/clients"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakClientRepresentation> findByClientId(@RequestParam(value="clientId", required=false) String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/clients/{id}"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakClientRepresentation getClientById(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.DELETE}, value={"/clients/{id}"})
    @Headers(value={"Content-Type: application/json"})
    public void deleteClient(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"/clients"})
    @Headers(value={"Content-Type: application/json"})
    public Response createClient(@RequestBody KeycloakClientRepresentation var1);

    @RequestMapping(method={RequestMethod.PUT}, value={"/clients/{id}"})
    @Headers(value={"Content-Type: application/json"})
    public void updateClient(@PathVariable(value="id") String var1, @RequestBody KeycloakClientRepresentation var2);

    @RequestMapping(method={RequestMethod.POST}, value={"/clients/{id}/client-secret"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakCredentialRepresentation generateNewClientSecret(@RequestBody KeycloakCredentialRequestRepresentation var1, @PathVariable(value="id") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/clients/{id}/client-secret"})
    @Headers(value={"Content-Type: application/json"})
    public KeycloakCredentialRepresentation getClientSecretById(@PathVariable(value="id") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"/users/{id}/role-mappings/clients/{client}/available"})
    @Headers(value={"Content-Type: application/json"})
    public List<KeycloakRoleMapping> getClientLevelRoleMappingAvailable(@PathVariable(value="id") String var1, @PathVariable(value="client") String var2);
}

