/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.identity.keycloak.model;

public class KeycloakCredentialRequestRepresentation {

    private String id;
    private String realm;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRealm() {
        return realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public static class Builder {

        private String id;
        private String realm;

        public static Builder newKeycloakCredentialRequestRepresentationBuilder() {
            return new Builder();
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public KeycloakCredentialRequestRepresentation build() {
            KeycloakCredentialRequestRepresentation keycloakClientRepresentation = new KeycloakCredentialRequestRepresentation();
            keycloakClientRepresentation.setRealm(realm);
            keycloakClientRepresentation.setId(id);
            return keycloakClientRepresentation;
        }
    }
}
