/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.keycloak;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.springframework.security.oauth2.jwt.Jwt;

public class KeycloakResourceJwtAdapter
implements JwtAdapter {
    private final String resourceId;
    private final Jwt jwt;

    public KeycloakResourceJwtAdapter(String resourceId, Jwt jwt) {
        this.resourceId = resourceId;
        this.jwt = jwt;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public List<String> getRoles() {
        return this.getFromClient(this.resourceId, "roles", this.jwt);
    }

    public List<String> getPermissions() {
        return this.getFromClient(this.resourceId, "permissions", this.jwt);
    }

    public List<String> getScopes() {
        return this.jwt.getClaimAsStringList("scope");
    }

    public List<String> getGroups() {
        if (this.jwt.hasClaim("groups")) {
            return this.jwt.getClaimAsStringList("groups");
        }
        return null;
    }

    public String getUserName() {
        return (String)this.jwt.getClaim("preferred_username");
    }

    private List<String> getFromClient(String clientId, String key, Jwt jwt) {
        Map resource;
        Map resourceAccess;
        if (jwt.hasClaim("resource_access") && (resourceAccess = (Map)jwt.getClaim("resource_access")).containsKey(clientId) && (resource = (Map)resourceAccess.get(clientId)).containsKey(key)) {
            return (List)resource.get(key);
        }
        return Collections.emptyList();
    }
}

