/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.activiti.api.runtime.shared.security.PrincipalRolesProvider;
import org.springframework.lang.NonNull;

public class JwtPrincipalRolesProviderChain
implements PrincipalRolesProvider {
    private final List<PrincipalRolesProvider> providers;

    public JwtPrincipalRolesProviderChain(@NonNull List<PrincipalRolesProvider> providers) {
        this.providers = Collections.unmodifiableList(providers);
    }

    public List<String> getRoles(@NonNull Principal principal) {
        return this.providers.stream().map(provider -> provider.getRoles(principal)).filter(Objects::nonNull).findFirst().orElseThrow(this::securityException);
    }

    protected SecurityException securityException() {
        return new SecurityException("Invalid principal security access token roles");
    }
}

