/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.security.Principal;
import org.activiti.api.runtime.shared.security.PrincipalIdentityProvider;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenProvider;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenValidator;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.springframework.lang.NonNull;

public class JwtPrincipalIdentityProvider
implements PrincipalIdentityProvider {
    private final JwtAccessTokenProvider keycloakAccessTokenProvider;
    private final JwtAccessTokenValidator jwtAccessTokenValidator;

    public JwtPrincipalIdentityProvider(@NonNull JwtAccessTokenProvider keycloakAccessTokenProvider, @NonNull JwtAccessTokenValidator jwtAccessTokenValidator) {
        this.keycloakAccessTokenProvider = keycloakAccessTokenProvider;
        this.jwtAccessTokenValidator = jwtAccessTokenValidator;
    }

    public String getUserId(@NonNull Principal principal) {
        return this.keycloakAccessTokenProvider.accessToken(principal).filter(this.jwtAccessTokenValidator::isValid).map(JwtAdapter::getUserName).orElseThrow(this::securityException);
    }

    protected SecurityException securityException() {
        return new SecurityException("Invalid accessToken object instance");
    }
}

