/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.activiti.cloud.services.common.security.jwt.OAuth2UserServiceCacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JwtUserInfoUriAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtUserInfoUriAuthenticationConverter.class);
    public static final String SESSION_ID_CLAIM = "sid";
    protected static final String SUBJECT_CLAIM = "sub";
    protected static final String USERNAME_CLAIM = "preferred_username";
    private final Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter;
    private final ClientRegistration clientRegistration;
    private final OAuth2UserServiceCacheable oAuth2UserServiceCacheable;

    public JwtUserInfoUriAuthenticationConverter(Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter, ClientRegistration clientRegistration, OAuth2UserServiceCacheable oAuth2UserServiceCacheable) {
        this.jwtGrantedAuthoritiesConverter = jwtGrantedAuthoritiesConverter;
        this.clientRegistration = clientRegistration;
        this.oAuth2UserServiceCacheable = oAuth2UserServiceCacheable;
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        Collection authorities = (Collection)this.jwtGrantedAuthoritiesConverter.convert((Object)jwt);
        String principalClaimValue = this.getPrincipalClaimName(jwt);
        return new JwtAuthenticationToken(jwt, authorities, principalClaimValue);
    }

    public String getPrincipalClaimName(Jwt jwt) {
        String cacheKey;
        String username = jwt.getClaimAsString(USERNAME_CLAIM);
        if (username == null && (cacheKey = this.getCacheKey(jwt)) != null) {
            List scope = jwt.getClaimAsStringList("scope");
            if (scope != null && scope.contains("openid")) {
                Instant issuedAt = jwt.getIssuedAt();
                Instant expiresAt = jwt.getExpiresAt();
                OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, jwt.getTokenValue(), issuedAt, expiresAt);
                OAuth2UserRequest userRequest = new OAuth2UserRequest(this.clientRegistration, accessToken);
                OAuth2User oAuth2User = this.oAuth2UserServiceCacheable.loadUser(userRequest, cacheKey);
                username = oAuth2User.getName();
            } else {
                LOGGER.warn("Cannot load user data for {} because the token has not openid scope", (Object)cacheKey);
                username = cacheKey;
                DefaultOAuth2User oAuth2User = new DefaultOAuth2User((Collection)this.jwtGrantedAuthoritiesConverter.convert((Object)jwt), jwt.getClaims(), SUBJECT_CLAIM);
                this.oAuth2UserServiceCacheable.putUser((OAuth2User)oAuth2User, cacheKey);
            }
        }
        return username;
    }

    private String getCacheKey(Jwt jwt) {
        return jwt.hasClaim(SESSION_ID_CLAIM) ? jwt.getClaimAsString(SESSION_ID_CLAIM) : jwt.getClaimAsString(SUBJECT_CLAIM);
    }
}

