/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.identity.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class IdentitySearchCacheConfiguration {
    @Value(value="${identity.client.cache.cacheExpireAfterWrite:PT5m}")
    private String cacheExpireAfterWrite;
    @Value(value="${identity.client.cache.cacheMaxSize:1000}")
    private int cacheMaxSize;

    @Bean
    public CaffeineCache userSearchCache() {
        return new CaffeineCache("userSearch", Caffeine.newBuilder().expireAfterWrite(Duration.parse(this.cacheExpireAfterWrite)).maximumSize((long)this.cacheMaxSize).build());
    }

    @Bean
    public CaffeineCache groupSearchCache() {
        return new CaffeineCache("groupSearch", Caffeine.newBuilder().expireAfterWrite(Duration.parse(this.cacheExpireAfterWrite)).maximumSize((long)this.cacheMaxSize).build());
    }
}

