/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.util.ArrayList;
import java.util.Collection;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenProvider;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;

public class JwtGrantedAuthorityConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private final JwtAccessTokenProvider jwtAccessTokenProvider;

    public JwtGrantedAuthorityConverter(JwtAccessTokenProvider jwtAccessTokenProvider) {
        this.jwtAccessTokenProvider = jwtAccessTokenProvider;
    }

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        JwtAdapter jwtAdapter = this.jwtAccessTokenProvider.accessToken(jwt);
        for (String role : jwtAdapter.getRoles()) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + role));
        }
        for (String permission : jwtAdapter.getPermissions()) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("PERMISSION_" + permission));
        }
        for (String scope : jwtAdapter.getScopes()) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("SCOPE_" + scope));
        }
        return grantedAuthorities;
    }
}

