/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.identity.model;

import java.util.Objects;

public class User {
    private String id;
    private String firstName;
    private String lastName;
    private String username;
    private String email;
    private String displayName;

    public User() {
    }

    public User(String id, String firstName, String lastName, String username, String email, String displayName) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
        this.email = email;
        this.displayName = displayName;
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User that = (User)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.username, this.email, this.displayName);
    }

    public String toString() {
        return "User{id='" + this.id + "', firstName='" + this.firstName + "', lastName='" + this.lastName + "', username='" + this.username + "', email='" + this.email + "', displayName='" + this.displayName + "'}";
    }

    public static class UserBuilder {
        private String id;
        private String firstName;
        private String lastName;
        private String username;
        private String email;
        private String displayName;

        public UserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public UserBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public UserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UserBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public User build() {
            return new User(this.id, this.firstName, this.lastName, this.username, this.email, this.displayName);
        }
    }
}

