/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.identity.web.controller;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.activiti.cloud.identity.GroupSearchParams;
import org.activiti.cloud.identity.IdentityManagementService;
import org.activiti.cloud.identity.UserSearchParams;
import org.activiti.cloud.identity.UserTypeSearchParam;
import org.activiti.cloud.identity.model.Group;
import org.activiti.cloud.identity.model.SecurityRequestBodyRepresentation;
import org.activiti.cloud.identity.model.SecurityResponseRepresentation;
import org.activiti.cloud.identity.model.User;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${activiti.cloud.services.identity.url:/v1}"}, produces={"application/json"})
public class IdentityManagementController {
    private final IdentityManagementService identityManagementService;

    public IdentityManagementController(IdentityManagementService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    @GetMapping(value={"/users"})
    @Cacheable(value={"userSearch"})
    public List<User> getUsers(@RequestParam(value="search", required=false) String search, @RequestParam(value="role", required=false) Set<String> roles, @RequestParam(value="group", required=false) Set<String> groups, @RequestParam(value="type", required=false) String type, @RequestParam(value="application", required=false) String application, @RequestParam(value="hideDeactivatedUser", required=false) Boolean filterDeactivatedUsers) {
        UserSearchParams userSearchParams = new UserSearchParams();
        userSearchParams.setSearch(search);
        userSearchParams.setGroups(groups);
        userSearchParams.setType(type == null ? null : UserTypeSearchParam.convertFromStringOrThrow(type));
        userSearchParams.setRoles(roles);
        userSearchParams.setApplication(application);
        userSearchParams.setFilterDeactivatedUsers(Optional.ofNullable(filterDeactivatedUsers).orElse(false));
        return this.identityManagementService.findUsers(userSearchParams);
    }

    @GetMapping(value={"/groups"})
    @Cacheable(value={"groupSearch"})
    public List<Group> getGroups(@RequestParam(value="search", required=false) String search, @RequestParam(value="role", required=false) Set<String> roles, @RequestParam(value="application", required=false) String application) {
        GroupSearchParams groupSearchParams = new GroupSearchParams();
        groupSearchParams.setSearch(search);
        groupSearchParams.setRoles(roles);
        groupSearchParams.setApplication(application);
        return this.identityManagementService.findGroups(groupSearchParams);
    }

    @PostMapping(value={"/permissions/{application}"})
    public void addApplicationPermissions(@PathVariable String application, @RequestBody List<SecurityRequestBodyRepresentation> securityRequestBodyRepresentations) {
        this.identityManagementService.addApplicationPermissions(application, securityRequestBodyRepresentations);
    }

    @GetMapping(value={"/permissions/{application}"})
    public List<SecurityResponseRepresentation> getApplicationPermissions(@PathVariable String application, @RequestParam(value="role", required=false) Set<String> roles) {
        return this.identityManagementService.getApplicationPermissions(application, roles);
    }

    @GetMapping(value={"/users/{id}"})
    public User getUsersById(@PathVariable String id) {
        return this.identityManagementService.findUserById(id);
    }
}

