/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.activiti.api.runtime.shared.security.PrincipalGroupsProvider;
import org.springframework.lang.NonNull;

public class JwtPrincipalGroupsProviderChain
implements PrincipalGroupsProvider {
    private final List<PrincipalGroupsProvider> providers;

    public JwtPrincipalGroupsProviderChain(@NonNull List<PrincipalGroupsProvider> providers) {
        this.providers = Collections.unmodifiableList(providers);
    }

    public List<String> getGroups(@NonNull Principal principal) {
        return this.providers.stream().map(provider -> provider.getGroups(principal)).filter(Objects::nonNull).findFirst().orElseThrow(this::securityException);
    }

    protected SecurityException securityException() {
        return new SecurityException("Invalid principal security access token groups");
    }
}

