/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.util.List;
import java.util.Optional;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.activiti.cloud.services.common.security.jwt.validator.ValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.Jwt;

public class JwtAccessTokenValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAccessTokenValidator.class);
    private final List<ValidationCheck> validationChecks;

    public JwtAccessTokenValidator(List<ValidationCheck> validationChecks) {
        this.validationChecks = validationChecks;
    }

    public boolean isValid(@NonNull JwtAdapter jwtAdapter) {
        return Optional.ofNullable(jwtAdapter).map(JwtAdapter::getJwt).map(this::isValid).orElseThrow(() -> new SecurityException("Invalid access token instance"));
    }

    public boolean isValid(Jwt accessToken) {
        return !this.validationChecks.stream().map(check -> {
            boolean valid = check.isValid(accessToken);
            if (!valid) {
                LOGGER.error("Token invalid because the {} validation has failed.", (Object)check.getClass().toString());
            }
            return valid;
        }).anyMatch(b -> b.equals(false));
    }
}

