/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.security.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;

public interface AuthTokenRequestInterceptor
extends RequestInterceptor {
    public static final String AUTHORIZATION = "Authorization";
    public static final String BEARER = "Bearer";

    public Optional<String> getToken();

    default public void apply(RequestTemplate template) {
        this.getToken().ifPresent(token -> {
            template.removeHeader(AUTHORIZATION);
            template.header(AUTHORIZATION, new String[]{String.format("%s %s", BEARER, token)});
        });
    }
}

