/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class CustomBearerTokenAccessDeniedHandler
implements AccessDeniedHandler {
    private final AccessDeniedHandler accessDeniedHandler;

    public CustomBearerTokenAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        this.accessDeniedHandler.handle(request, response, accessDeniedException);
        this.setStatusWithReasonIfErrorIs403(response);
    }

    private void setStatusWithReasonIfErrorIs403(HttpServletResponse response) throws IOException {
        if (response.getStatus() == 403) {
            response.sendError(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase());
        }
    }
}

