/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.security.Principal;
import java.util.Optional;
import java.util.function.Function;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JwtAccessTokenProvider {
    private final Function<Jwt, JwtAdapter> function;

    public JwtAccessTokenProvider(Function<Jwt, JwtAdapter> supplier) {
        this.function = supplier;
    }

    public JwtAdapter accessToken(@NonNull Jwt jwt) {
        return this.function.apply(jwt);
    }

    public Optional<JwtAdapter> accessToken(@NonNull Principal principal) {
        return Optional.of(principal).filter(JwtAuthenticationToken.class::isInstance).map(JwtAuthenticationToken.class::cast).map(jwtAuthenticationToken -> this.accessToken((Jwt)jwtAuthenticationToken.getToken()));
    }
}

