/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.identity;

import java.util.Set;

public class UserSearchParams {

    private String search;
    private Set<String> groups;
    private Set<String> roles;
    private UserTypeSearchParam type;
    private String application;
    private boolean filterDeactivatedUsers;

    public String getSearchKey() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public Set<String> getGroups() {
        return groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public UserTypeSearchParam getType() {
        return type;
    }

    public void setType(UserTypeSearchParam type) {
        this.type = type;
    }

    public String getApplication() {
        return application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public boolean isFilterDeactivatedUsers() {
        return filterDeactivatedUsers;
    }

    public void setFilterDeactivatedUsers(boolean filterDeactivatedUsers) {
        this.filterDeactivatedUsers = filterDeactivatedUsers;
    }
}
