/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.identity.web;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.activiti.cloud.identity.config.IdentitySearchCacheConfiguration;
import org.activiti.cloud.identity.web.controller.IdentityManagementController;
import org.activiti.cloud.identity.web.controller.IdentityManagementRestExceptionHandler;
import org.springframework.context.annotation.Import;

/**
 * This annotation enables the IdentityManagementRestController that exposes
 * users and groups search using the target identity management service (e.g. Keycloak)
 */
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Import(
    {
        IdentityManagementController.class,
        IdentityManagementRestExceptionHandler.class,
        IdentitySearchCacheConfiguration.class,
    }
)
public @interface EnableIdentityManagementRestAPI {
}
