/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.identity.web.controller;

import static org.springframework.http.HttpStatus.BAD_REQUEST;
import static org.springframework.http.HttpStatus.NOT_FOUND;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.activiti.cloud.identity.exceptions.*;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(Ordered.HIGHEST_PRECEDENCE)
public class IdentityManagementRestExceptionHandler {

    @ExceptionHandler(
        {
            IdentityInvalidUserRoleException.class,
            IdentityInvalidUserException.class,
            IdentityInvalidRoleException.class,
            IdentityInvalidGroupException.class,
            IdentityInvalidGroupRoleException.class,
            IdentityInvalidUserTypeException.class,
        }
    )
    @ResponseStatus(BAD_REQUEST)
    public void handleAppException(Exception ex, HttpServletResponse response) throws IOException {
        response.sendError(BAD_REQUEST.value(), ex.getMessage());
    }

    @ExceptionHandler(IdentityInvalidApplicationException.class)
    @ResponseStatus(NOT_FOUND)
    public void handleAppException(IdentityInvalidApplicationException ex, HttpServletResponse response)
        throws IOException {
        response.sendError(NOT_FOUND.value(), ex.getMessage());
    }
}
