/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.security.feign;

import java.util.Optional;
import org.activiti.api.runtime.shared.security.SecurityContextTokenProvider;

/**
 * Feign request interceptor for forwarding the bearer token
 */
public class TokenRelayRequestInterceptor implements AuthTokenRequestInterceptor {

    private final SecurityContextTokenProvider securityContextTokenProvider;

    public TokenRelayRequestInterceptor(SecurityContextTokenProvider securityContextTokenProvider) {
        this.securityContextTokenProvider = securityContextTokenProvider;
    }

    @Override
    public Optional<String> getToken() {
        return securityContextTokenProvider.getCurrentToken();
    }
}
