/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.common.security.jwt;

import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class OAuth2UserServiceCacheable {

    private final OAuth2UserService oAuth2UserService;

    public OAuth2UserServiceCacheable(OAuth2UserService oAuth2UserService) {
        this.oAuth2UserService = oAuth2UserService;
    }

    @Cacheable(value = "userInfoApiCall", key = "#cacheKey", sync = true)
    public OAuth2User loadUser(OAuth2UserRequest userRequest, String cacheKey) throws OAuth2AuthenticationException {
        return oAuth2UserService.loadUser(userRequest);
    }

    @CachePut(value = "userInfoApiCall", key = "#cacheKey")
    public OAuth2User putUser(OAuth2User user, String cacheKey) {
        return user;
    }
}
