/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.activiti.cloud.services.common.file.FileContent;

public class ZipBuilder {
    private static final String ZIP_PATH_DELIMITATOR = "/";
    private String name;
    private Set<String> entries = new TreeSet<String>();
    private Map<String, byte[]> contentMap = new HashMap<String, byte[]>();
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public ZipBuilder(String name) {
        this.name = name;
    }

    public ZipBuilder appendFolder(String ... path) {
        String entry = Arrays.stream(path).collect(Collectors.joining(ZIP_PATH_DELIMITATOR, "", ZIP_PATH_DELIMITATOR));
        this.entries.add(entry);
        return this;
    }

    public ZipBuilder appendFile(byte[] content, String ... path) {
        String entry = String.join((CharSequence)ZIP_PATH_DELIMITATOR, path);
        this.entries.add(entry);
        this.contentMap.put(entry, content);
        return this;
    }

    public ZipBuilder appendFile(FileContent fileContent, String ... path) {
        String[] newPath = Arrays.copyOf(path, path.length + 1);
        newPath[path.length] = fileContent.getFilename();
        return this.appendFile(fileContent.getFileContent(), newPath);
    }

    public ByteArrayOutputStream toByteArrayOutputStream() throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ByteArrayOutputStream byteArrayOutputStream;
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                for (String entry : this.entries) {
                    zipOutputStream.putNextEntry(new ZipEntry(entry));
                    byte[] content = this.contentMap.get(entry);
                    if (content != null) {
                        this.writeChunked(content, zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.close();
                byteArrayOutputStream = outputStream;
            }
            return byteArrayOutputStream;
        }
    }

    public void writeToFile(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.toByteArrayOutputStream().writeTo(outputStream);
        }
    }

    public byte[] toZipBytes() throws IOException {
        return this.toByteArrayOutputStream().toByteArray();
    }

    public FileContent toZipFileContent() throws IOException {
        return new FileContent(this.name + ".zip", "application/zip", this.toZipBytes());
    }

    private void writeChunked(byte[] data, ZipOutputStream output) throws IOException {
        if (data != null) {
            int bytes = data.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 4096);
                output.write(data, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }
}

