/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.behavior;

import java.util.Collection;
import java.util.Date;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.api.process.model.impl.IntegrationRequestImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationRequestedEventImpl;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.listeners.ProcessEngineEventsAggregator;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.DelegateExecutionFunction;
import org.activiti.engine.impl.bpmn.behavior.DelegateExecutionOutcome;
import org.activiti.engine.impl.persistence.entity.Entity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextManager;
import org.activiti.runtime.api.connector.DefaultServiceTaskBehavior;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.services.connectors.IntegrationRequestSender;
import org.activiti.services.connectors.channel.IntegrationRequestBuilder;
import org.activiti.services.connectors.enricher.IntegrationContextEnricher;

public class MQServiceTaskBehavior
implements DelegateExecutionFunction {
    private final IntegrationContextManager integrationContextManager;
    private final IntegrationContextBuilder integrationContextBuilder;
    private final DefaultServiceTaskBehavior defaultServiceTaskBehavior;
    private final ProcessEngineEventsAggregator processEngineEventsAggregator;
    private final RuntimeBundleProperties runtimeBundleProperties;
    private final IntegrationRequestBuilder integrationRequestBuilder;
    private final IntegrationRequestSender integrationRequestSender;
    private final Collection<IntegrationContextEnricher> integrationContextEnrichers;

    public MQServiceTaskBehavior(IntegrationContextManager integrationContextManager, IntegrationRequestSender integrationRequestSender, IntegrationContextBuilder integrationContextBuilder, DefaultServiceTaskBehavior defaultServiceTaskBehavior, ProcessEngineEventsAggregator processEngineEventsAggregator, RuntimeBundleProperties runtimeBundleProperties, IntegrationRequestBuilder integrationRequestBuilder, Collection<IntegrationContextEnricher> integrationContextEnrichers) {
        this.integrationContextManager = integrationContextManager;
        this.integrationRequestSender = integrationRequestSender;
        this.integrationContextBuilder = integrationContextBuilder;
        this.integrationRequestBuilder = integrationRequestBuilder;
        this.defaultServiceTaskBehavior = defaultServiceTaskBehavior;
        this.processEngineEventsAggregator = processEngineEventsAggregator;
        this.runtimeBundleProperties = runtimeBundleProperties;
        this.integrationContextEnrichers = integrationContextEnrichers;
    }

    public DelegateExecutionOutcome apply(DelegateExecution execution) {
        if (this.defaultServiceTaskBehavior.hasConnectorBean(execution)) {
            return this.defaultServiceTaskBehavior.apply(execution);
        }
        IntegrationContext integrationContext = this.integrationContextBuilder.from(this.storeIntegrationContext(execution), execution);
        this.enrichIntegrationContext(integrationContext);
        this.sendIntegrationRequest(integrationContext);
        this.aggregateCloudIntegrationRequestedEvent(integrationContext);
        return DelegateExecutionOutcome.WAIT_FOR_TRIGGER;
    }

    private void enrichIntegrationContext(IntegrationContext integrationContext) {
        if (this.integrationContextEnrichers != null) {
            this.integrationContextEnrichers.forEach(enricher -> enricher.enrich(integrationContext));
        }
    }

    private void aggregateCloudIntegrationRequestedEvent(IntegrationContext integrationContext) {
        if (this.runtimeBundleProperties.getEventsProperties().isIntegrationAuditEventsEnabled()) {
            CloudIntegrationRequestedEventImpl cloudEvent = new CloudIntegrationRequestedEventImpl(integrationContext);
            this.processEngineEventsAggregator.add((CloudRuntimeEvent)cloudEvent);
        }
    }

    private void sendIntegrationRequest(IntegrationContext integrationContext) {
        IntegrationRequestImpl integrationRequest = this.integrationRequestBuilder.build(integrationContext);
        this.integrationRequestSender.sendIntegrationRequest((IntegrationRequest)integrationRequest);
    }

    private IntegrationContextEntity storeIntegrationContext(DelegateExecution execution) {
        IntegrationContextEntity integrationContext = this.buildIntegrationContext(execution);
        this.integrationContextManager.insert((Entity)integrationContext);
        return integrationContext;
    }

    private IntegrationContextEntity buildIntegrationContext(DelegateExecution execution) {
        IntegrationContextEntity integrationContext = (IntegrationContextEntity)this.integrationContextManager.create();
        integrationContext.setExecutionId(execution.getId());
        integrationContext.setProcessInstanceId(execution.getProcessInstanceId());
        integrationContext.setProcessDefinitionId(execution.getProcessDefinitionId());
        integrationContext.setFlowNodeId(execution.getCurrentActivityId());
        integrationContext.setCreatedDate(new Date());
        return integrationContext;
    }
}

