/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.channel;

import java.util.Optional;
import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;

class PropagateCloudBpmnErrorCmd
implements Command<Void> {
    private final DelegateExecution execution;
    private final IntegrationError integrationError;

    PropagateCloudBpmnErrorCmd(IntegrationError integrationError, DelegateExecution execution) {
        this.integrationError = integrationError;
        this.execution = execution;
    }

    public Void execute(CommandContext commandContext) {
        String errorCode = Optional.ofNullable(this.integrationError.getErrorCode()).orElse(this.integrationError.getErrorMessage());
        this.propagateError(errorCode);
        return null;
    }

    protected void propagateError(String errorCode) {
        ErrorPropagation.propagateError((String)errorCode, (DelegateExecution)this.execution);
    }
}

