/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.argument.resolver;

import org.activiti.cloud.alfresco.argument.resolver.AlfrescoQueryParameters;
import org.activiti.cloud.alfresco.argument.resolver.MaxItemsParameter;
import org.activiti.cloud.alfresco.argument.resolver.SkipCountParameter;
import org.springframework.web.context.request.NativeWebRequest;

public class AlfrescoPageParameterParser {
    private final int defaultPageSize;

    public AlfrescoPageParameterParser(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public AlfrescoQueryParameters parseParameters(NativeWebRequest webRequest) {
        return new AlfrescoQueryParameters(this.parseSkipCount(webRequest), this.parseMaxItems(webRequest));
    }

    protected MaxItemsParameter parseMaxItems(NativeWebRequest webRequest) {
        boolean isSet;
        int maxItems = this.defaultPageSize;
        String maxItemsString = webRequest.getParameter("maxItems");
        boolean bl = isSet = maxItemsString != null;
        if (isSet) {
            maxItems = Integer.parseInt(maxItemsString);
        }
        return new MaxItemsParameter(isSet, maxItems);
    }

    protected SkipCountParameter parseSkipCount(NativeWebRequest webRequest) {
        boolean isSet;
        long skipCount = 0L;
        String skipCountString = webRequest.getParameter("skipCount");
        boolean bl = isSet = skipCountString != null;
        if (isSet) {
            skipCount = Long.parseLong(skipCountString);
        }
        return new SkipCountParameter(isSet, skipCount);
    }
}

