/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.data.domain;

import java.util.Collection;
import org.activiti.cloud.alfresco.data.domain.ExtendedPageMetadata;
import org.activiti.cloud.alfresco.data.domain.ExtendedPageMetadataConverter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.lang.Nullable;
import org.springframework.web.util.UriComponents;

public class AlfrescoPagedModelAssembler<T>
extends PagedResourcesAssembler<T> {
    private final ExtendedPageMetadataConverter extendedPageMetadataConverter;

    public AlfrescoPagedModelAssembler(@Nullable HateoasPageableHandlerMethodArgumentResolver resolver, @Nullable UriComponents baseUri, ExtendedPageMetadataConverter extendedPageMetadataConverter) {
        super(resolver, baseUri);
        this.extendedPageMetadataConverter = extendedPageMetadataConverter == null ? new ExtendedPageMetadataConverter() : extendedPageMetadataConverter;
    }

    public <R extends RepresentationModel<?>> PagedModel<R> toModel(Pageable pageable, Page<T> page, RepresentationModelAssembler<T, R> assembler) {
        PagedModel pagedModel = this.toModel(page, assembler);
        ExtendedPageMetadata extendedPageMetadata = this.extendedPageMetadataConverter.toExtendedPageMetadata(pageable.getOffset(), pagedModel.getMetadata());
        pagedModel = PagedModel.of((Collection)pagedModel.getContent(), (PagedModel.PageMetadata)extendedPageMetadata, (Iterable)pagedModel.getLinks());
        return pagedModel;
    }
}

