/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.alfresco.rest.model;

import java.util.List;

public class EntriesResponseContent<T> {

    private List<EntryResponseContent<T>> entries;

    private PaginationMetadata pagination;

    public EntriesResponseContent() {}

    public EntriesResponseContent(List<EntryResponseContent<T>> entries, PaginationMetadata pagination) {
        this.entries = entries;
        this.pagination = pagination;
    }

    public List<EntryResponseContent<T>> getEntries() {
        return entries;
    }

    public PaginationMetadata getPagination() {
        return pagination;
    }
}
