/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.cloud.services.events.message.AbstractMessageHeadersRoutingKeyResolver;
import org.activiti.cloud.services.events.message.MessageBuilderAppender;
import org.activiti.cloud.services.events.message.RoutingKeyResolver;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public class MessageBuilderAppenderChain {
    private static final String ROUTING_KEY = "routingKey";
    private static final String MESSAGE_PAYLOAD_TYPE = "messagePayloadType";
    private final List<MessageBuilderAppender> appenders = new ArrayList<MessageBuilderAppender>();
    private RoutingKeyResolver<Map<String, Object>> routingKeyResolver = new DefaultRoutingKeyResolver();

    public <P> MessageBuilder<P> withPayload(P payload) {
        Assert.notNull(payload, (String)"payload must not be null");
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.setLeaveMutable(true);
        MessageBuilder messageBuilder = MessageBuilder.withPayload(payload).setHeaders(accessor);
        messageBuilder.setHeader(MESSAGE_PAYLOAD_TYPE, (Object)payload.getClass().getName());
        for (MessageBuilderAppender appender : this.appenders) {
            appender.apply(messageBuilder);
        }
        this.resolveRoutingKey(accessor.getMessageHeaders()).ifPresent(routingKey -> accessor.setHeader(ROUTING_KEY, routingKey));
        return messageBuilder;
    }

    protected Optional<String> resolveRoutingKey(MessageHeaders messageHeaders) {
        return Optional.ofNullable(this.routingKeyResolver.resolve((Map<String, Object>)messageHeaders));
    }

    public MessageBuilderAppenderChain chain(MessageBuilderAppender filter) {
        Assert.notNull((Object)filter, (String)"filter must not be null");
        this.appenders.add(filter);
        return this;
    }

    public MessageBuilderAppenderChain routingKeyResolver(RoutingKeyResolver<Map<String, Object>> routingKeyResolver) {
        Assert.notNull(routingKeyResolver, (String)"routingKeyResolver must not be null");
        this.routingKeyResolver = routingKeyResolver;
        return this;
    }

    static class DefaultRoutingKeyResolver
    extends AbstractMessageHeadersRoutingKeyResolver {
        private static final String EVENT_MESSAGE = "eventMessage";

        DefaultRoutingKeyResolver() {
        }

        @Override
        public String resolve(Map<String, Object> headers) {
            return this.build(headers, MessageBuilderAppenderChain.MESSAGE_PAYLOAD_TYPE);
        }

        @Override
        public String getPrefix() {
            return EVENT_MESSAGE;
        }
    }
}

